/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.sf.jasperreports.engine.util.FileResolver;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.ThreadLocalStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JRResourcesUtil {
    private static FileResolver globalFileResolver;
    private static ThreadLocalStack localFileResolverStack;
    private static URLStreamHandlerFactory globalURLHandlerFactory;
    private static ThreadLocalStack localURLHandlerFactoryStack;
    private static ClassLoader globalClassLoader;
    private static ThreadLocalStack localClassLoaderStack;

    public static URL createURL(String spec, URLStreamHandlerFactory urlHandlerFactory) {
        URL url;
        URLStreamHandler handler = JRResourcesUtil.getURLHandler(spec, urlHandlerFactory);
        try {
            url = handler == null ? new URL(spec) : new URL(null, spec, handler);
        }
        catch (MalformedURLException e2) {
            url = null;
        }
        return url;
    }

    public static URLStreamHandler getURLHandler(String spec, URLStreamHandlerFactory urlHandlerFact) {
        String protocol;
        URLStreamHandlerFactory urlHandlerFactory = JRResourcesUtil.getURLHandlerFactory(urlHandlerFact);
        URLStreamHandler handler = null;
        if (urlHandlerFactory != null && (protocol = JRResourcesUtil.getURLProtocol(spec)) != null) {
            handler = urlHandlerFactory.createURLStreamHandler(protocol);
        }
        return handler;
    }

    private static String getURLProtocol(String urlSpec) {
        String proto;
        String protocol = null;
        String spec = urlSpec.trim();
        int colon = spec.indexOf(58);
        if (colon > 0 && JRResourcesUtil.protocolValid(proto = spec.substring(0, colon))) {
            protocol = proto;
        }
        return protocol;
    }

    private static boolean protocolValid(String protocol) {
        int length = protocol.length();
        if (length < 1) {
            return false;
        }
        if (!Character.isLetter(protocol.charAt(0))) {
            return false;
        }
        for (int i2 = 1; i2 < length; ++i2) {
            char c2 = protocol.charAt(i2);
            if (Character.isLetterOrDigit(c2) || c2 == '+' || c2 == '-' || c2 == '.') continue;
            return false;
        }
        return true;
    }

    public static FileResolver getFileResolver(FileResolver fileRes) {
        FileResolver fileResolver = fileRes;
        if (fileResolver == null && (fileResolver = JRResourcesUtil.getThreadFileResolver()) == null) {
            fileResolver = globalFileResolver;
        }
        return fileResolver;
    }

    public static FileResolver getGlobalFileResolver() {
        return globalFileResolver;
    }

    public static FileResolver getThreadFileResolver() {
        return (FileResolver)localFileResolverStack.top();
    }

    public static void setThreadFileResolver(FileResolver fileResolver) {
        localFileResolverStack.push(fileResolver);
    }

    public static void resetThreadFileResolver() {
        localFileResolverStack.pop();
    }

    public static void setGlobalFileResolver(FileResolver fileResolver) {
        globalFileResolver = fileResolver;
    }

    public static File resolveFile(String location, FileResolver fileRes) {
        FileResolver fileResolver = JRResourcesUtil.getFileResolver(fileRes);
        if (fileResolver != null) {
            return fileResolver.resolveFile(location);
        }
        File file = new File(location);
        if (file.exists() && file.isFile()) {
            return file;
        }
        return null;
    }

    public static URLStreamHandlerFactory getURLHandlerFactory(URLStreamHandlerFactory urlHandlerFact) {
        URLStreamHandlerFactory urlHandlerFactory = urlHandlerFact;
        if (urlHandlerFactory == null && (urlHandlerFactory = JRResourcesUtil.getThreadURLStreamHandlerFactory()) == null) {
            urlHandlerFactory = globalURLHandlerFactory;
        }
        return urlHandlerFactory;
    }

    public static URLStreamHandlerFactory getGlobalURLStreamHandlerFactory() {
        return globalURLHandlerFactory;
    }

    public static URLStreamHandlerFactory getThreadURLStreamHandlerFactory() {
        return (URLStreamHandlerFactory)localURLHandlerFactoryStack.top();
    }

    public static void setThreadURLHandlerFactory(URLStreamHandlerFactory urlHandlerFactory) {
        localURLHandlerFactoryStack.push(urlHandlerFactory);
    }

    public static void resetThreadURLHandlerFactory() {
        localURLHandlerFactoryStack.pop();
    }

    public static void setGlobalURLHandlerFactory(URLStreamHandlerFactory urlHandlerFactory) {
        globalURLHandlerFactory = urlHandlerFactory;
    }

    public static ClassLoader getClassLoader(ClassLoader clsLoader) {
        ClassLoader classLoader = clsLoader;
        if (classLoader == null && (classLoader = JRResourcesUtil.getThreadClassLoader()) == null) {
            classLoader = globalClassLoader;
        }
        return classLoader;
    }

    public static ClassLoader getGlobalClassLoader() {
        return globalClassLoader;
    }

    public static ClassLoader getThreadClassLoader() {
        return (ClassLoader)localClassLoaderStack.top();
    }

    public static void setThreadClassLoader(ClassLoader classLoader) {
        localClassLoaderStack.push(classLoader);
    }

    public static void resetClassLoader() {
        localClassLoaderStack.pop();
    }

    public static void setGlobalClassLoader(ClassLoader classLoader) {
        globalClassLoader = classLoader;
    }

    public static URL findClassLoaderResource(String location, ClassLoader clsLoader, Class<?> clazz) {
        ClassLoader classLoader = JRResourcesUtil.getClassLoader(clsLoader);
        URL url = null;
        if (classLoader != null) {
            url = classLoader.getResource(location);
        }
        if (url == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                url = classLoader.getResource(location);
            }
            if (url == null) {
                classLoader = clazz.getClassLoader();
                url = classLoader == null ? clazz.getResource("/" + location) : classLoader.getResource(location);
            }
        }
        return url;
    }

    public static URL findClassLoaderResource(String location, ClassLoader clsLoader) {
        ClassLoader classLoader = JRResourcesUtil.getClassLoader(clsLoader);
        URL url = null;
        if (classLoader != null) {
            url = classLoader.getResource(location);
        }
        if (url == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                url = classLoader.getResource(location);
            }
            if (url == null) {
                classLoader = JRLoader.class.getClassLoader();
                url = classLoader == null ? JRLoader.class.getResource("/" + location) : classLoader.getResource(location);
            }
        }
        return url;
    }

    public static ResourceBundle loadResourceBundle(String baseName, Locale locale) {
        return JRResourcesUtil.loadResourceBundle(baseName, locale, null);
    }

    public static ResourceBundle loadResourceBundle(String baseName, Locale locale, ClassLoader clsLoader) {
        ResourceBundle resourceBundle = null;
        ClassLoader classLoader = JRResourcesUtil.getClassLoader(clsLoader);
        if (classLoader != null) {
            try {
                resourceBundle = ResourceBundle.getBundle(baseName, locale, classLoader);
            }
            catch (MissingResourceException e2) {
                // empty catch block
            }
        }
        if (resourceBundle == null && (classLoader = Thread.currentThread().getContextClassLoader()) != null) {
            try {
                resourceBundle = ResourceBundle.getBundle(baseName, locale, classLoader);
            }
            catch (MissingResourceException e3) {
                // empty catch block
            }
        }
        if (resourceBundle == null) {
            classLoader = JRClassLoader.class.getClassLoader();
            resourceBundle = classLoader == null ? ResourceBundle.getBundle(baseName, locale) : ResourceBundle.getBundle(baseName, locale, classLoader);
        }
        return resourceBundle;
    }

    private JRResourcesUtil() {
    }

    static {
        localFileResolverStack = new ThreadLocalStack();
        localURLHandlerFactoryStack = new ThreadLocalStack();
        localClassLoaderStack = new ThreadLocalStack();
    }
}

