/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedMap<K, V> {
    private final LinkedValue<K, V> header;
    private final HashMap<K, LinkedValue<K, V>> map = new HashMap();

    public LinkedMap() {
        this.header = new LinkedValue<Object, Object>(null, null);
        ((LinkedValue)this.header).prev = (LinkedValue)this.header;
        ((LinkedValue)this.header).next = (LinkedValue)this.header;
    }

    public void add(K key, V value) {
        if (key != null && this.map.containsKey(key)) {
            return;
        }
        LinkedValue<K, V> entry = new LinkedValue<K, V>(key, value);
        ((LinkedValue)entry).prev = ((LinkedValue)this.header).prev;
        ((LinkedValue)entry).next = (LinkedValue)this.header;
        ((LinkedValue)this.header).prev.next = (LinkedValue)entry;
        ((LinkedValue)this.header).prev = (LinkedValue)entry;
        if (key != null) {
            this.map.put(key, entry);
        }
    }

    public void addFirst(K key, V value) {
        if (key != null && this.map.containsKey(key)) {
            return;
        }
        LinkedValue<K, V> entry = new LinkedValue<K, V>(key, value);
        ((LinkedValue)entry).next = ((LinkedValue)this.header).next;
        ((LinkedValue)entry).prev = (LinkedValue)this.header;
        ((LinkedValue)this.header).next.prev = (LinkedValue)entry;
        ((LinkedValue)this.header).next = (LinkedValue)entry;
        if (key != null) {
            this.map.put(key, entry);
        }
    }

    public boolean isEmpty() {
        return ((LinkedValue)this.header).next == this.header;
    }

    public V pop() {
        if (((LinkedValue)this.header).next == this.header) {
            throw new IllegalStateException("Empty map");
        }
        LinkedValue entry = ((LinkedValue)this.header).next;
        entry.prev.next = entry.next;
        entry.next.prev = entry.prev;
        if (entry.key != null) {
            this.map.remove(entry.key);
        }
        return (V)entry.value;
    }

    public V remove(K key) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null");
        }
        LinkedValue<K, V> entry = this.map.remove(key);
        if (entry == null) {
            return null;
        }
        ((LinkedValue)entry).prev.next = ((LinkedValue)entry).next;
        ((LinkedValue)entry).next.prev = ((LinkedValue)entry).prev;
        return (V)((LinkedValue)entry).value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class LinkedValue<K, V> {
        private LinkedValue<K, V> prev;
        private LinkedValue<K, V> next;
        private K key;
        private V value;

        protected LinkedValue(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }
}

