/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.io.IOException;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRParagraph;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRStyleContainer;
import net.sf.jasperreports.engine.TabStop;
import net.sf.jasperreports.engine.util.JRXmlWriteHelper;
import net.sf.jasperreports.engine.util.XmlNamespace;

public abstract class JRXmlBaseWriter {
    protected JRXmlWriteHelper writer;

    protected void useWriter(JRXmlWriteHelper aWriter) {
        this.writer = aWriter;
    }

    protected void writeStyle(JRStyle style) throws IOException {
        this.writer.startElement("style");
        this.writer.addEncodedAttribute("name", style.getName());
        this.writer.addAttribute("isDefault", style.isDefault(), false);
        this.writeStyleReferenceAttr(style);
        this.writer.addAttribute("mode", style.getOwnModeValue());
        this.writer.addAttribute("forecolor", style.getOwnForecolor());
        this.writer.addAttribute("backcolor", style.getOwnBackcolor());
        this.writer.addAttribute("fill", style.getOwnFillValue());
        this.writer.addAttribute("radius", style.getOwnRadius());
        this.writer.addAttribute("scaleImage", style.getOwnScaleImageValue());
        this.writer.addAttribute("hAlign", style.getOwnHorizontalAlignmentValue());
        this.writer.addAttribute("vAlign", style.getOwnVerticalAlignmentValue());
        this.writer.addAttribute("rotation", style.getOwnRotationValue());
        this.writer.addAttribute("markup", style.getOwnMarkup());
        this.writer.addEncodedAttribute("pattern", style.getOwnPattern());
        this.writer.addAttribute("isBlankWhenNull", style.isOwnBlankWhenNull());
        this.writer.addEncodedAttribute("fontName", style.getOwnFontName());
        this.writer.addAttribute("fontSize", style.getOwnFontSize());
        this.writer.addAttribute("isBold", style.isOwnBold());
        this.writer.addAttribute("isItalic", style.isOwnItalic());
        this.writer.addAttribute("isUnderline", style.isOwnUnderline());
        this.writer.addAttribute("isStrikeThrough", style.isOwnStrikeThrough());
        this.writer.addEncodedAttribute("pdfFontName", style.getOwnPdfFontName());
        this.writer.addEncodedAttribute("pdfEncoding", style.getOwnPdfEncoding());
        this.writer.addAttribute("isPdfEmbedded", style.isOwnPdfEmbedded());
        this.writePen(style.getLinePen());
        this.writeBox(style.getLineBox());
        this.writeParagraph(style.getParagraph());
        if (this.toWriteConditionalStyles()) {
            JRConditionalStyle[] conditionalStyles = style.getConditionalStyles();
            if (!(style instanceof JRConditionalStyle) && conditionalStyles != null) {
                for (int i2 = 0; i2 < conditionalStyles.length; ++i2) {
                    this.writeConditionalStyle(conditionalStyles[i2]);
                }
            }
        }
        this.writer.closeElement();
    }

    public void writeStyleReferenceAttr(JRStyleContainer styleContainer) {
        if (!(styleContainer instanceof JRConditionalStyle)) {
            if (styleContainer.getStyle() != null) {
                this.writer.addEncodedAttribute("style", styleContainer.getStyle().getName());
            } else if (styleContainer.getStyleNameReference() != null) {
                this.writer.addEncodedAttribute("style", styleContainer.getStyleNameReference());
            }
        }
    }

    protected abstract boolean toWriteConditionalStyles();

    protected void writeConditionalStyle(JRConditionalStyle style) throws IOException {
        this.writer.startElement("conditionalStyle");
        this.writer.writeExpression("conditionExpression", style.getConditionExpression());
        this.writeStyle(style);
        this.writer.closeElement();
    }

    protected void writePen(JRPen pen) throws IOException {
        this.writePen("pen", pen);
    }

    private void writePen(String element, JRPen pen) throws IOException {
        this.writer.startElement(element);
        this.writer.addAttribute("lineWidth", pen.getOwnLineWidth());
        this.writer.addAttribute("lineStyle", pen.getOwnLineStyleValue());
        this.writer.addAttribute("lineColor", pen.getOwnLineColor());
        this.writer.closeElement(true);
    }

    public void writeBox(JRLineBox box) throws IOException {
        this.writeBox(box, null);
    }

    public void writeBox(JRLineBox box, XmlNamespace namespace) throws IOException {
        if (box != null) {
            this.writer.startElement("box", namespace);
            this.writer.addAttribute("padding", box.getOwnPadding());
            this.writer.addAttribute("topPadding", box.getOwnTopPadding());
            this.writer.addAttribute("leftPadding", box.getOwnLeftPadding());
            this.writer.addAttribute("bottomPadding", box.getOwnBottomPadding());
            this.writer.addAttribute("rightPadding", box.getOwnRightPadding());
            this.writePen("pen", box.getPen());
            this.writePen("topPen", box.getTopPen());
            this.writePen("leftPen", box.getLeftPen());
            this.writePen("bottomPen", box.getBottomPen());
            this.writePen("rightPen", box.getRightPen());
            this.writer.closeElement(true);
        }
    }

    public void writeParagraph(JRParagraph paragraph) throws IOException {
        this.writeParagraph(paragraph, null);
    }

    public void writeParagraph(JRParagraph paragraph, XmlNamespace namespace) throws IOException {
        if (paragraph != null) {
            this.writer.startElement("paragraph", namespace);
            this.writer.addAttribute("lineSpacing", paragraph.getOwnLineSpacing());
            this.writer.addAttribute("lineSpacingSize", paragraph.getOwnLineSpacingSize());
            this.writer.addAttribute("firstLineIndent", paragraph.getOwnFirstLineIndent());
            this.writer.addAttribute("leftIndent", paragraph.getOwnLeftIndent());
            this.writer.addAttribute("rightIndent", paragraph.getOwnRightIndent());
            this.writer.addAttribute("spacingBefore", paragraph.getOwnSpacingBefore());
            this.writer.addAttribute("spacingAfter", paragraph.getOwnSpacingAfter());
            this.writer.addAttribute("tabStopWidth", paragraph.getOwnTabStopWidth());
            TabStop[] tabStops = paragraph.getTabStops();
            if (tabStops != null && tabStops.length > 0) {
                for (int i2 = 0; i2 < tabStops.length; ++i2) {
                    this.writeTabStop(tabStops[i2]);
                }
            }
            this.writer.closeElement(true);
        }
    }

    public void writeTabStop(TabStop tabStop) throws IOException {
        if (tabStop != null) {
            this.writer.startElement("tabStop");
            this.writer.addAttribute("position", tabStop.getPosition());
            this.writer.addAttribute("alignment", tabStop.getAlignment());
            this.writer.closeElement(true);
        }
    }
}

