/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.renderers;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import net.sf.jasperreports.engine.JRAbstractSvgRenderer;
import net.sf.jasperreports.engine.JRRuntimeException;

public class AwtComponentRenderer
extends JRAbstractSvgRenderer {
    private static final long serialVersionUID = 1L;
    private Component component;

    public AwtComponentRenderer(Component component) {
        this.component = component;
    }

    public Dimension2D getDimension() {
        return this.component.getSize();
    }

    public void render(Graphics2D grx, Rectangle2D rectangle) {
        AffineTransform origTransform = grx.getTransform();
        try {
            Dimension size = this.component.getSize();
            grx.translate(rectangle.getX(), rectangle.getY());
            if (rectangle.getWidth() != size.getWidth() || rectangle.getHeight() != size.getHeight()) {
                grx.scale(rectangle.getWidth() / size.getWidth(), rectangle.getHeight() / size.getHeight());
            }
            this.component.paint(grx);
        }
        catch (Exception e2) {
            throw new JRRuntimeException(e2);
        }
        finally {
            grx.setTransform(origTransform);
        }
    }
}

