/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.repo;

import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.repo.CastorDataAdapterPersistenceService;
import net.sf.jasperreports.repo.FileRepositoryService;
import net.sf.jasperreports.repo.InputStreamPersistenceService;
import net.sf.jasperreports.repo.InputStreamResource;
import net.sf.jasperreports.repo.OutputStreamPersistenceService;
import net.sf.jasperreports.repo.OutputStreamResource;
import net.sf.jasperreports.repo.PersistenceService;
import net.sf.jasperreports.repo.PersistenceServiceFactory;
import net.sf.jasperreports.repo.ReportResource;
import net.sf.jasperreports.repo.RepositoryService;
import net.sf.jasperreports.repo.Resource;
import net.sf.jasperreports.repo.SerializedReportPersistenceService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileRepositoryPersistenceServiceFactory
implements PersistenceServiceFactory {
    private static final FileRepositoryPersistenceServiceFactory INSTANCE = new FileRepositoryPersistenceServiceFactory();

    public static FileRepositoryPersistenceServiceFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public <K extends RepositoryService, L extends Resource, M extends PersistenceService> M getPersistenceService(Class<K> repositoryServiceType, Class<L> resourceType) {
        if (FileRepositoryService.class.isAssignableFrom(repositoryServiceType)) {
            if (InputStreamResource.class.getName().equals(resourceType.getName())) {
                return (M)new InputStreamPersistenceService();
            }
            if (OutputStreamResource.class.getName().equals(resourceType.getName())) {
                return (M)new OutputStreamPersistenceService();
            }
            if (ReportResource.class.getName().equals(resourceType.getName())) {
                return (M)new SerializedReportPersistenceService();
            }
            if (DataAdapter.class.isAssignableFrom(resourceType)) {
                return (M)new CastorDataAdapterPersistenceService();
            }
        }
        return null;
    }
}

