/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.collection.CompositeCollection;
import org.apache.commons.collections.set.CompositeSet;

public class CompositeMap
implements Map {
    private Map[] composite;
    private MapMutator mutator;

    public CompositeMap() {
        this(new Map[0], null);
    }

    public CompositeMap(Map one, Map two) {
        this(new Map[]{one, two}, null);
    }

    public CompositeMap(Map one, Map two, MapMutator mutator) {
        this(new Map[]{one, two}, mutator);
    }

    public CompositeMap(Map[] composite) {
        this(composite, null);
    }

    public CompositeMap(Map[] composite, MapMutator mutator) {
        this.mutator = mutator;
        this.composite = new Map[0];
        int i2 = composite.length - 1;
        while (i2 >= 0) {
            this.addComposited(composite[i2]);
            --i2;
        }
    }

    public void setMutator(MapMutator mutator) {
        this.mutator = mutator;
    }

    public synchronized void addComposited(Map map) throws IllegalArgumentException {
        int i2 = this.composite.length - 1;
        while (i2 >= 0) {
            Collection intersect = CollectionUtils.intersection(this.composite[i2].keySet(), map.keySet());
            if (intersect.size() != 0) {
                if (this.mutator == null) {
                    throw new IllegalArgumentException("Key collision adding Map to CompositeMap");
                }
                this.mutator.resolveCollision(this, this.composite[i2], map, intersect);
            }
            --i2;
        }
        Map[] temp = new Map[this.composite.length + 1];
        System.arraycopy(this.composite, 0, temp, 0, this.composite.length);
        temp[temp.length - 1] = map;
        this.composite = temp;
    }

    public synchronized Map removeComposited(Map map) {
        int size = this.composite.length;
        int i2 = 0;
        while (i2 < size) {
            if (this.composite[i2].equals(map)) {
                Map[] temp = new Map[size - 1];
                System.arraycopy(this.composite, 0, temp, 0, i2);
                System.arraycopy(this.composite, i2 + 1, temp, i2, size - i2 - 1);
                this.composite = temp;
                return map;
            }
            ++i2;
        }
        return null;
    }

    public void clear() {
        int i2 = this.composite.length - 1;
        while (i2 >= 0) {
            this.composite[i2].clear();
            --i2;
        }
    }

    public boolean containsKey(Object key) {
        int i2 = this.composite.length - 1;
        while (i2 >= 0) {
            if (this.composite[i2].containsKey(key)) {
                return true;
            }
            --i2;
        }
        return false;
    }

    public boolean containsValue(Object value) {
        int i2 = this.composite.length - 1;
        while (i2 >= 0) {
            if (this.composite[i2].containsValue(value)) {
                return true;
            }
            --i2;
        }
        return false;
    }

    public Set entrySet() {
        CompositeSet entries = new CompositeSet();
        int i2 = this.composite.length - 1;
        while (i2 >= 0) {
            entries.addComposited(this.composite[i2].entrySet());
            --i2;
        }
        return entries;
    }

    public Object get(Object key) {
        int i2 = this.composite.length - 1;
        while (i2 >= 0) {
            if (this.composite[i2].containsKey(key)) {
                return this.composite[i2].get(key);
            }
            --i2;
        }
        return null;
    }

    public boolean isEmpty() {
        int i2 = this.composite.length - 1;
        while (i2 >= 0) {
            if (!this.composite[i2].isEmpty()) {
                return false;
            }
            --i2;
        }
        return true;
    }

    public Set keySet() {
        CompositeSet keys = new CompositeSet();
        int i2 = this.composite.length - 1;
        while (i2 >= 0) {
            keys.addComposited(this.composite[i2].keySet());
            --i2;
        }
        return keys;
    }

    public Object put(Object key, Object value) {
        if (this.mutator == null) {
            throw new UnsupportedOperationException("No mutator specified");
        }
        return this.mutator.put(this, this.composite, key, value);
    }

    public void putAll(Map map) {
        if (this.mutator == null) {
            throw new UnsupportedOperationException("No mutator specified");
        }
        this.mutator.putAll(this, this.composite, map);
    }

    public Object remove(Object key) {
        int i2 = this.composite.length - 1;
        while (i2 >= 0) {
            if (this.composite[i2].containsKey(key)) {
                return this.composite[i2].remove(key);
            }
            --i2;
        }
        return null;
    }

    public int size() {
        int size = 0;
        int i2 = this.composite.length - 1;
        while (i2 >= 0) {
            size += this.composite[i2].size();
            --i2;
        }
        return size;
    }

    public Collection values() {
        CompositeCollection keys = new CompositeCollection();
        int i2 = this.composite.length - 1;
        while (i2 >= 0) {
            keys.addComposited(this.composite[i2].values());
            --i2;
        }
        return keys;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Map) {
            Map map = (Map)obj;
            return this.entrySet().equals(map.entrySet());
        }
        return false;
    }

    public int hashCode() {
        int code = 0;
        Iterator i2 = this.entrySet().iterator();
        while (i2.hasNext()) {
            code += i2.next().hashCode();
        }
        return code;
    }

    public static interface MapMutator {
        public void resolveCollision(CompositeMap var1, Map var2, Map var3, Collection var4);

        public Object put(CompositeMap var1, Map[] var2, Object var3, Object var4);

        public void putAll(CompositeMap var1, Map[] var2, Map var3);
    }
}

