/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.asn1;

import java.io.IOException;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.asn1.BerOutputStream;

public class ASN1Any
extends ASN1Type {
    private static final ASN1Any ASN1 = new ASN1Any();

    public ASN1Any() {
        super(0);
    }

    public static ASN1Any getInstance() {
        return ASN1;
    }

    @Override
    public final boolean checkTag(int n2) {
        return true;
    }

    @Override
    public Object decode(BerInputStream berInputStream) throws IOException {
        berInputStream.readContent();
        if (berInputStream.isVerify) {
            return null;
        }
        return this.getDecodedObject(berInputStream);
    }

    @Override
    public Object getDecodedObject(BerInputStream berInputStream) throws IOException {
        byte[] byArray = new byte[berInputStream.offset - berInputStream.tagOffset];
        System.arraycopy(berInputStream.buffer, berInputStream.tagOffset, byArray, 0, byArray.length);
        return byArray;
    }

    @Override
    public void encodeASN(BerOutputStream berOutputStream) {
        berOutputStream.encodeANY();
    }

    @Override
    public void encodeContent(BerOutputStream berOutputStream) {
        berOutputStream.encodeANY();
    }

    @Override
    public void setEncodingContent(BerOutputStream berOutputStream) {
        berOutputStream.length = ((byte[])berOutputStream.content).length;
    }

    @Override
    public int getEncodedLength(BerOutputStream berOutputStream) {
        return berOutputStream.length;
    }
}

