/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.asn1;

import org.apache.harmony.security.asn1.ASN1Choice;
import org.apache.harmony.security.asn1.ASN1Explicit;
import org.apache.harmony.security.asn1.ASN1Sequence;
import org.apache.harmony.security.asn1.ASN1SequenceOf;
import org.apache.harmony.security.asn1.ASN1Set;
import org.apache.harmony.security.asn1.ASN1SetOf;
import org.apache.harmony.security.asn1.BitString;

public class BerOutputStream {
    public byte[] encoded;
    protected int offset;
    public int length;
    public Object content;

    public final void encodeTag(int n2) {
        this.encoded[this.offset++] = (byte)n2;
        if (this.length > 127) {
            int n3;
            int n4 = 1;
            for (n3 = this.length >> 8; n3 > 0; n3 >>= 8) {
                n4 = (byte)(n4 + 1);
            }
            this.encoded[this.offset] = (byte)(n4 | 0x80);
            ++this.offset;
            n3 = this.length;
            int n5 = this.offset + n4 - 1;
            int n6 = 0;
            while (n6 < n4) {
                this.encoded[n5 - n6] = (byte)n3;
                ++n6;
                n3 >>= 8;
            }
            this.offset += n4;
        } else {
            this.encoded[this.offset++] = (byte)this.length;
        }
    }

    public void encodeANY() {
        System.arraycopy(this.content, 0, this.encoded, this.offset, this.length);
        this.offset += this.length;
    }

    public void encodeBitString() {
        BitString bitString = (BitString)this.content;
        this.encoded[this.offset] = (byte)bitString.unusedBits;
        System.arraycopy(bitString.bytes, 0, this.encoded, this.offset + 1, this.length - 1);
        this.offset += this.length;
    }

    public void encodeBoolean() {
        this.encoded[this.offset] = (Boolean)this.content != false ? -1 : 0;
        ++this.offset;
    }

    public void encodeChoice(ASN1Choice aSN1Choice) {
        throw new RuntimeException("Is not implemented yet");
    }

    public void encodeExplicit(ASN1Explicit aSN1Explicit) {
        throw new RuntimeException("Is not implemented yet");
    }

    public void encodeGeneralizedTime() {
        System.arraycopy(this.content, 0, this.encoded, this.offset, this.length);
        this.offset += this.length;
    }

    public void encodeUTCTime() {
        System.arraycopy(this.content, 0, this.encoded, this.offset, this.length);
        this.offset += this.length;
    }

    public void encodeInteger() {
        System.arraycopy(this.content, 0, this.encoded, this.offset, this.length);
        this.offset += this.length;
    }

    public void encodeOctetString() {
        System.arraycopy(this.content, 0, this.encoded, this.offset, this.length);
        this.offset += this.length;
    }

    public void encodeOID() {
        int n2;
        int[] nArray = (int[])this.content;
        int n3 = this.length;
        int n4 = nArray.length - 1;
        while (n4 > 1) {
            n2 = nArray[n4];
            if (n2 > 127) {
                this.encoded[this.offset + n3 - 1] = (byte)(n2 & 0x7F);
                n2 >>= 7;
                while (n2 > 0) {
                    this.encoded[this.offset + --n3 - 1] = (byte)(n2 | 0x80);
                    n2 >>= 7;
                }
            } else {
                this.encoded[this.offset + n3 - 1] = (byte)n2;
            }
            --n4;
            --n3;
        }
        n2 = nArray[0] * 40 + nArray[1];
        if (n2 > 127) {
            this.encoded[this.offset + n3 - 1] = (byte)(n2 & 0x7F);
            n2 >>= 7;
            while (n2 > 0) {
                this.encoded[this.offset + --n3 - 1] = (byte)(n2 | 0x80);
                n2 >>= 7;
            }
        } else {
            this.encoded[this.offset + n3 - 1] = (byte)n2;
        }
        this.offset += this.length;
    }

    public void encodeSequence(ASN1Sequence aSN1Sequence) {
        throw new RuntimeException("Is not implemented yet");
    }

    public void encodeSequenceOf(ASN1SequenceOf aSN1SequenceOf) {
        throw new RuntimeException("Is not implemented yet");
    }

    public void encodeSet(ASN1Set aSN1Set) {
        throw new RuntimeException("Is not implemented yet");
    }

    public void encodeSetOf(ASN1SetOf aSN1SetOf) {
        throw new RuntimeException("Is not implemented yet");
    }

    public void encodeString() {
        System.arraycopy(this.content, 0, this.encoded, this.offset, this.length);
        this.offset += this.length;
    }

    public void getChoiceLength(ASN1Choice aSN1Choice) {
        throw new RuntimeException("Is not implemented yet");
    }

    public void getExplicitLength(ASN1Explicit aSN1Explicit) {
        throw new RuntimeException("Is not implemented yet");
    }

    public void getSequenceLength(ASN1Sequence aSN1Sequence) {
        throw new RuntimeException("Is not implemented yet");
    }

    public void getSequenceOfLength(ASN1SequenceOf aSN1SequenceOf) {
        throw new RuntimeException("Is not implemented yet");
    }

    public void getSetLength(ASN1Set aSN1Set) {
        throw new RuntimeException("Is not implemented yet");
    }

    public void getSetOfLength(ASN1SetOf aSN1SetOf) {
        throw new RuntimeException("Is not implemented yet");
    }

    public int getStringLength(Object object) {
        throw new RuntimeException("Is not implemented yet");
    }
}

