/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.asn1;

import org.apache.harmony.security.internal.nls.Messages;

public final class BitString {
    private static final byte[] SET_MASK = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
    private static final byte[] RESET_MASK = new byte[]{127, -65, -33, -17, -9, -5, -3, -2};
    public final byte[] bytes;
    public final int unusedBits;

    public BitString(byte[] byArray, int n2) {
        if (n2 < 0 || n2 > 7) {
            throw new IllegalArgumentException(Messages.getString("security.13D"));
        }
        if (byArray.length == 0 && n2 != 0) {
            throw new IllegalArgumentException(Messages.getString("security.13E"));
        }
        this.bytes = byArray;
        this.unusedBits = n2;
    }

    public BitString(boolean[] blArray) {
        this.unusedBits = blArray.length % 8;
        int n2 = blArray.length / 8;
        if (this.unusedBits != 0) {
            ++n2;
        }
        this.bytes = new byte[n2];
        for (int i2 = 0; i2 < blArray.length; ++i2) {
            this.setBit(i2, blArray[i2]);
        }
    }

    public boolean getBit(int n2) {
        int n3 = n2 / 8;
        int n4 = n2 % 8;
        return (this.bytes[n3] & SET_MASK[n4]) != 0;
    }

    public void setBit(int n2, boolean bl) {
        int n3 = n2 % 8;
        int n4 = n2 / 8;
        if (bl) {
            int n5 = n4;
            this.bytes[n5] = (byte)(this.bytes[n5] | SET_MASK[n3]);
        } else {
            int n6 = n4;
            this.bytes[n6] = (byte)(this.bytes[n6] & RESET_MASK[n3]);
        }
    }

    public boolean[] toBooleanArray() {
        boolean[] blArray = new boolean[this.bytes.length * 8 - this.unusedBits];
        for (int i2 = 0; i2 < blArray.length; ++i2) {
            blArray[i2] = this.getBit(i2);
        }
        return blArray;
    }
}

