/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.asn1;

import java.util.Arrays;
import org.apache.harmony.security.internal.nls.Messages;

public final class ObjectIdentifier {
    private final int[] oid;
    private String soid;

    public ObjectIdentifier(int[] nArray) {
        ObjectIdentifier.validate(nArray);
        this.oid = nArray;
    }

    public ObjectIdentifier(String string) {
        this.oid = ObjectIdentifier.toIntArray(string);
        this.soid = string;
    }

    public int[] getOid() {
        return this.oid;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return Arrays.equals(this.oid, ((ObjectIdentifier)object).oid);
    }

    public String toString() {
        if (this.soid == null) {
            this.soid = ObjectIdentifier.toString(this.oid);
        }
        return this.soid;
    }

    public int hashCode() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.oid.length && i2 < 4; ++i2) {
            n2 += this.oid[i2] << 8 * i2;
        }
        return n2 & Integer.MAX_VALUE;
    }

    public static void validate(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException(Messages.getString("security.98"));
        }
        if (nArray.length < 2) {
            throw new IllegalArgumentException(Messages.getString("security.99"));
        }
        if (nArray[0] > 2) {
            throw new IllegalArgumentException(Messages.getString("security.9A"));
        }
        if (nArray[0] != 2 && nArray[1] > 39) {
            throw new IllegalArgumentException(Messages.getString("security.9B"));
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] >= 0) continue;
            throw new IllegalArgumentException(Messages.getString("security.9C"));
        }
    }

    public static String toString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer(3 * nArray.length);
        for (int i2 = 0; i2 < nArray.length - 1; ++i2) {
            stringBuffer.append(nArray[i2]);
            stringBuffer.append('.');
        }
        stringBuffer.append(nArray[nArray.length - 1]);
        return stringBuffer.toString();
    }

    public static int[] toIntArray(String string) {
        char c2;
        if (string == null) {
            throw new IllegalArgumentException(Messages.getString("security.9D"));
        }
        int n2 = string.length();
        if (n2 == 0) {
            throw new IllegalArgumentException(Messages.getString("security.9E"));
        }
        int n3 = 1;
        boolean bl = true;
        for (int i2 = 0; i2 < n2; ++i2) {
            c2 = string.charAt(i2);
            if (c2 == '.') {
                if (bl) {
                    throw new IllegalArgumentException(Messages.getString("security.9E"));
                }
                bl = true;
                ++n3;
                continue;
            }
            if (c2 >= '0' && c2 <= '9') {
                bl = false;
                continue;
            }
            throw new IllegalArgumentException(Messages.getString("security.9E"));
        }
        if (bl) {
            throw new IllegalArgumentException(Messages.getString("security.9E"));
        }
        if (n3 < 2) {
            throw new IllegalArgumentException(Messages.getString("security.99"));
        }
        int[] nArray = new int[n3];
        int n4 = 0;
        for (int i3 = 0; i3 < n2; ++i3) {
            c2 = string.charAt(i3);
            if (c2 == '.') {
                ++n4;
                continue;
            }
            nArray[n4] = nArray[n4] * 10 + c2 - 48;
        }
        if (nArray[0] > 2) {
            throw new IllegalArgumentException(Messages.getString("security.9A"));
        }
        if (nArray[0] != 2 && nArray[1] > 39) {
            throw new IllegalArgumentException(Messages.getString("security.9B"));
        }
        return nArray;
    }
}

