/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.fortress;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;

public class BootstrapHelper {
    private static final String BOOTSTRAP_PROVIDER_NAME = "com.ibm.security.bootstrap.BootstrapProvider";
    private static Provider bootstrapProvider = null;
    private static final ThreadLocal<Integer> inJarVerifer = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    private static final ThreadLocal<Integer> inFIPSLoading = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    private static final ThreadLocal<Boolean> inProvidersLoading = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public static Provider getBootstrapProvider() {
        if (null != bootstrapProvider) {
            return bootstrapProvider;
        }
        bootstrapProvider = AccessController.doPrivileged(new PrivilegedAction<Provider>(){

            @Override
            public Provider run() {
                try {
                    return (Provider)Class.forName(BootstrapHelper.BOOTSTRAP_PROVIDER_NAME).newInstance();
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
        });
        return bootstrapProvider;
    }

    public static void beginJarVerify() {
        int n2 = inJarVerifer.get();
        inJarVerifer.set(++n2);
    }

    public static void endJarVerify() {
        int n2 = inJarVerifer.get();
        inJarVerifer.set(--n2);
    }

    public static boolean isInJarVerify() {
        return inJarVerifer.get() > 0;
    }

    static void beginFIPSLoading() {
        int n2 = inFIPSLoading.get();
        inFIPSLoading.set(++n2);
    }

    static void endFIPSLoading() {
        int n2 = inFIPSLoading.get();
        inFIPSLoading.set(--n2);
    }

    static boolean isInFIPSLoading() {
        return inFIPSLoading.get() > 0;
    }

    static void beginProvidersLoading() {
        inProvidersLoading.set(true);
    }

    static void endProvidersLoading() {
        inProvidersLoading.set(false);
    }

    static boolean isInProvidersLoading() {
        return inProvidersLoading.get();
    }
}

