/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.fortress;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.URIParameter;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.harmony.security.PolicyEntry;
import org.apache.harmony.security.fortress.DefaultPolicyParser;
import org.apache.harmony.security.fortress.PolicyUtils;

public class DefaultPolicy
extends Policy {
    public static final String JAVA_SECURITY_POLICY = "java.security.policy";
    public static final String POLICY_URL_PREFIX = "policy.url.";
    private final Set<PolicyEntry> grants = new HashSet<PolicyEntry>();
    private final Map<Object, Collection<Permission>> cache = new WeakHashMap<Object, Collection<Permission>>();
    private final DefaultPolicyParser parser;
    private boolean initialized;
    private static ProtectionDomainCache pdCache;

    public static void setProtectionDomainCache(ProtectionDomainCache protectionDomainCache) {
        pdCache = protectionDomainCache;
    }

    public DefaultPolicy() {
        this(new DefaultPolicyParser());
    }

    public DefaultPolicy(boolean bl) {
        this(new DefaultPolicyParser(), bl);
    }

    public DefaultPolicy(DefaultPolicyParser defaultPolicyParser) {
        this(defaultPolicyParser, true);
    }

    public DefaultPolicy(DefaultPolicyParser defaultPolicyParser, boolean bl) {
        this.parser = defaultPolicyParser;
        this.initialized = false;
        if (bl) {
            this.refreshImpl(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PermissionCollection getPermissions(ProtectionDomain protectionDomain) {
        Collection<Permission> collection;
        if (!this.initialized) {
            collection = this;
            synchronized (collection) {
                if (!this.initialized) {
                    this.refresh();
                }
            }
        }
        if ((collection = pdCache.get(protectionDomain)) == null) {
            collection = pdCache.get(protectionDomain);
            if (collection == null) {
                collection = new HashSet<Permission>();
                for (PolicyEntry policyEntry : this.grants) {
                    if (!policyEntry.impliesPrincipals(protectionDomain == null ? null : protectionDomain.getPrincipals()) || !policyEntry.impliesCodeSource(protectionDomain == null ? null : protectionDomain.getCodeSource())) continue;
                    collection.addAll(policyEntry.getPermissions());
                }
            }
            ProtectionDomainCache protectionDomainCache = pdCache;
            synchronized (protectionDomainCache) {
                if (pdCache.get(protectionDomain) == null) {
                    pdCache.put(protectionDomain, collection);
                }
            }
        }
        return PolicyUtils.toPermissionCollection(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PermissionCollection getPermissions(CodeSource codeSource) {
        HashSet<Permission> hashSet;
        if (!this.initialized) {
            hashSet = this;
            synchronized (hashSet) {
                if (!this.initialized) {
                    this.refresh();
                }
            }
        }
        if ((hashSet = this.cache.get(codeSource)) == null) {
            hashSet = new HashSet<Permission>();
            for (PolicyEntry object2 : this.grants) {
                if (!object2.impliesPrincipals(null) || !object2.impliesCodeSource(codeSource)) continue;
                hashSet.addAll(object2.getPermissions());
            }
            Map<Object, Collection<Permission>> map = this.cache;
            synchronized (map) {
                if (this.cache.get(codeSource) == null) {
                    this.cache.put(codeSource, hashSet);
                }
            }
        }
        return PolicyUtils.toPermissionCollection((Collection<Permission>)hashSet);
    }

    @Override
    public synchronized void refresh() {
        this.refreshImpl(null);
    }

    public synchronized void refresh(URIParameter uRIParameter) {
        this.refreshImpl(uRIParameter);
    }

    private void refreshImpl(final URIParameter uRIParameter) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() {
                HashSet<PolicyEntry> hashSet = new HashSet<PolicyEntry>();
                Properties properties = new Properties(AccessController.doPrivileged(new PolicyUtils.SystemKit()));
                properties.setProperty("/", File.separator);
                URL[] uRLArray = PolicyUtils.getPolicyURLs(properties, DefaultPolicy.JAVA_SECURITY_POLICY, DefaultPolicy.POLICY_URL_PREFIX);
                boolean bl = true;
                if (uRIParameter != null) {
                    try {
                        URL uRL = uRIParameter.getURI().toURL();
                        hashSet.addAll(DefaultPolicy.this.parser.parse(uRL, properties));
                        bl = false;
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw new IllegalArgumentException(malformedURLException);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (bl) {
                    for (int i2 = 0; i2 < uRLArray.length; ++i2) {
                        try {
                            hashSet.addAll(DefaultPolicy.this.parser.parse(uRLArray[i2], properties));
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                DefaultPolicy.this.grants.clear();
                DefaultPolicy.this.grants.addAll(hashSet);
                Object object = DefaultPolicy.this.cache;
                synchronized (object) {
                    DefaultPolicy.this.cache.clear();
                }
                if (pdCache != null) {
                    object = pdCache;
                    synchronized (object) {
                        pdCache.clear();
                    }
                }
                DefaultPolicy.this.initialized = true;
                return null;
            }
        });
    }

    @Override
    public boolean implies(ProtectionDomain protectionDomain, Permission permission) {
        if (permission == null) {
            throw new NullPointerException();
        }
        boolean bl = false;
        if (protectionDomain != null) {
            PermissionCollection permissionCollection = this.getPermissions(protectionDomain);
            PermissionCollection permissionCollection2 = protectionDomain.getPermissions();
            if (permissionCollection2 != null) {
                Enumeration<Permission> enumeration = permissionCollection2.elements();
                while (enumeration.hasMoreElements()) {
                    permissionCollection.add(enumeration.nextElement());
                }
            }
            bl = permissionCollection.implies(permission);
        }
        return bl;
    }

    public static interface ProtectionDomainCache {
        public Collection<Permission> get(ProtectionDomain var1);

        public void put(ProtectionDomain var1, Collection<Permission> var2);

        public void clear();
    }
}

