/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.fortress;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import org.apache.harmony.security.Util;
import org.apache.harmony.security.fortress.BootstrapHelper;
import org.apache.harmony.security.fortress.SecurityAccess;
import org.apache.harmony.security.fortress.Services;
import org.apache.harmony.security.internal.nls.Messages;

public class Engine {
    private String serviceName;
    private Provider.Service returnedService;
    private String lastAlgorithm;
    private int refreshNumber;
    public Provider provider;
    public Object spi;
    public static SecurityAccess door;

    public Engine(String string) {
        this.serviceName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceResult getInstance(String string, Object object) throws NoSuchAlgorithmException {
        String string2;
        String string3 = string2 = string == null ? null : Util.toUpperCase(string);
        if (BootstrapHelper.isInJarVerify()) {
            return this.getInstance(string2, BootstrapHelper.getBootstrapProvider(), object);
        }
        if (BootstrapHelper.isInFIPSLoading() || BootstrapHelper.isInProvidersLoading()) {
            try {
                return this.getInstance(string2, BootstrapHelper.getBootstrapProvider(), object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string == null) {
            throw new NoSuchAlgorithmException(Messages.getString("security.149"));
        }
        Engine engine = this;
        synchronized (engine) {
            Provider.Service service;
            Services.refresh();
            if (this.returnedService != null && string2.equals(this.lastAlgorithm) && this.refreshNumber == Services.getRefreshNumber()) {
                service = this.returnedService;
            } else {
                service = Services.getService(new StringBuffer(128).append(this.serviceName).append(".").append(string2).toString());
                if (service == null) {
                    throw new NoSuchAlgorithmException(Messages.getString("security.14A", this.serviceName, string));
                }
                this.returnedService = service;
                this.lastAlgorithm = string2;
                this.refreshNumber = Services.getRefreshNumber();
            }
            this.spi = service.newInstance(object);
            this.provider = service.getProvider();
            ServiceResult serviceResult = new ServiceResult(this.spi, this.provider, service);
            return serviceResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceResult getInstanceUpperCase(String string, Object object) throws NoSuchAlgorithmException {
        if (BootstrapHelper.isInJarVerify()) {
            ServiceResult serviceResult = this.getInstance(string, BootstrapHelper.getBootstrapProvider(), object);
            return serviceResult;
        }
        if (BootstrapHelper.isInFIPSLoading() || BootstrapHelper.isInProvidersLoading()) {
            try {
                ServiceResult serviceResult = this.getInstance(string, BootstrapHelper.getBootstrapProvider(), object);
                return serviceResult;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string == null) {
            throw new NoSuchAlgorithmException(Messages.getString("security.149"));
        }
        Engine engine = this;
        synchronized (engine) {
            Provider.Service service;
            Services.refresh();
            if (this.returnedService != null && string.equals(this.lastAlgorithm) && this.refreshNumber == Services.getRefreshNumber()) {
                service = this.returnedService;
            } else {
                service = Services.getService(new StringBuffer(128).append(this.serviceName).append(".").append(string).toString());
                if (service == null) {
                    throw new NoSuchAlgorithmException(Messages.getString("security.14A", this.serviceName, string));
                }
                this.returnedService = service;
                this.lastAlgorithm = string;
                this.refreshNumber = Services.getRefreshNumber();
            }
            this.spi = service.newInstance(object);
            this.provider = service.getProvider();
            ServiceResult serviceResult = new ServiceResult(this.spi, this.provider, service);
            return serviceResult;
        }
    }

    public ServiceResult getInstance(String string, Provider provider, Object object) throws NoSuchAlgorithmException {
        Provider.Service service = null;
        if (string == null) {
            throw new NoSuchAlgorithmException(Messages.getString("security.14B", this.serviceName));
        }
        service = provider.getService(this.serviceName, string);
        if (service == null) {
            throw new NoSuchAlgorithmException(Messages.getString("security.14A", this.serviceName, string));
        }
        ServiceResult serviceResult = new ServiceResult(service.newInstance(object), provider, service);
        return serviceResult;
    }

    public static class ServiceResult {
        public Object spi;
        public Provider provider;
        public Provider.Service service;

        public ServiceResult(Object object, Provider provider, Provider.Service service) {
            this.spi = object;
            this.provider = provider;
            this.service = service;
        }
    }
}

