/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.utils;

import java.util.Arrays;
import org.apache.harmony.security.internal.nls.Messages;

public final class ObjectIdentifier {
    private final int[] oid;
    private int hash = -1;
    private String soid;
    private String sOID;
    private String name;
    private Object group;

    public ObjectIdentifier(int[] nArray) {
        ObjectIdentifier.validateOid(nArray);
        this.oid = nArray;
    }

    public ObjectIdentifier(int[] nArray, String string, Object object) {
        this(nArray);
        if (object == null) {
            throw new NullPointerException(Messages.getString("security.172"));
        }
        this.group = object;
        this.name = string;
        this.toOIDString();
    }

    public int[] getOid() {
        return this.oid;
    }

    public String getName() {
        return this.name;
    }

    public Object getGroup() {
        return this.group;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return Arrays.equals(this.oid, ((ObjectIdentifier)object).oid);
    }

    public String toOIDString() {
        if (this.sOID == null) {
            this.sOID = "OID." + this.toString();
        }
        return this.sOID;
    }

    public String toString() {
        if (this.soid == null) {
            StringBuffer stringBuffer = new StringBuffer(4 * this.oid.length);
            for (int i2 = 0; i2 < this.oid.length - 1; ++i2) {
                stringBuffer.append(this.oid[i2]);
                stringBuffer.append('.');
            }
            stringBuffer.append(this.oid[this.oid.length - 1]);
            this.soid = stringBuffer.toString();
        }
        return this.soid;
    }

    public int hashCode() {
        if (this.hash == -1) {
            this.hash = ObjectIdentifier.hashIntArray(this.oid);
        }
        return this.hash;
    }

    public static void validateOid(int[] nArray) {
        if (nArray == null) {
            throw new NullPointerException(Messages.getString("security.98"));
        }
        if (nArray.length < 2) {
            throw new IllegalArgumentException(Messages.getString("security.99"));
        }
        if (nArray[0] > 2) {
            throw new IllegalArgumentException(Messages.getString("security.9A"));
        }
        if (nArray[0] != 2 && nArray[1] > 39) {
            throw new IllegalArgumentException(Messages.getString("security.9B"));
        }
    }

    public static int hashIntArray(int[] nArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < nArray.length && i2 < 4; ++i2) {
            n2 += nArray[i2] << 8 * i2;
        }
        return n2 & Integer.MAX_VALUE;
    }
}

