/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.x501;

import java.io.IOException;
import org.apache.harmony.security.asn1.ASN1StringType;
import org.apache.harmony.security.asn1.DerInputStream;
import org.apache.harmony.security.x501.DirectoryString;
import org.apache.harmony.security.x509.Utils;

public class AttributeValue {
    public final boolean wasEncoded;
    public String escapedString;
    private String hexString;
    private int tag = -1;
    public byte[] encoded;
    public byte[] bytes;
    public boolean hasQE;
    public String rawString;

    public AttributeValue(String string, boolean bl) {
        this.wasEncoded = false;
        this.hasQE = bl;
        this.rawString = string;
        this.escapedString = this.makeEscaped(this.rawString);
    }

    public AttributeValue(String string, byte[] byArray) {
        this.wasEncoded = true;
        this.hexString = string;
        this.encoded = byArray;
        try {
            DerInputStream derInputStream = new DerInputStream(byArray);
            this.tag = derInputStream.tag;
            if (DirectoryString.ASN1.checkTag(this.tag)) {
                this.rawString = (String)DirectoryString.ASN1.decode(derInputStream);
                this.escapedString = this.makeEscaped(this.rawString);
            } else {
                this.rawString = string;
                this.escapedString = string;
            }
        }
        catch (IOException iOException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            illegalArgumentException.initCause(iOException);
            throw illegalArgumentException;
        }
    }

    public AttributeValue(String string, byte[] byArray, int n2) {
        this.wasEncoded = true;
        this.encoded = byArray;
        this.tag = n2;
        if (string == null) {
            this.rawString = this.getHexString();
            this.escapedString = this.hexString;
        } else {
            this.rawString = string;
            this.escapedString = this.makeEscaped(string);
        }
    }

    public int getTag() {
        if (this.tag == -1) {
            this.tag = Utils.isPrintableString(this.rawString) ? ASN1StringType.PRINTABLESTRING.id : ASN1StringType.UTF8STRING.id;
        }
        return this.tag;
    }

    public String getHexString() {
        if (this.hexString == null) {
            if (!this.wasEncoded) {
                this.encoded = Utils.isPrintableString(this.rawString) ? ASN1StringType.PRINTABLESTRING.encode(this.rawString) : ASN1StringType.UTF8STRING.encode(this.rawString);
            }
            StringBuffer stringBuffer = new StringBuffer(this.encoded.length * 2 + 1);
            stringBuffer.append('#');
            for (int i2 = 0; i2 < this.encoded.length; ++i2) {
                int n2 = this.encoded[i2] >> 4 & 0xF;
                if (n2 < 10) {
                    stringBuffer.append((char)(n2 + 48));
                } else {
                    stringBuffer.append((char)(n2 + 87));
                }
                n2 = this.encoded[i2] & 0xF;
                if (n2 < 10) {
                    stringBuffer.append((char)(n2 + 48));
                    continue;
                }
                stringBuffer.append((char)(n2 + 87));
            }
            this.hexString = stringBuffer.toString();
        }
        return this.hexString;
    }

    public void appendQEString(StringBuffer stringBuffer) {
        stringBuffer.append('\"');
        if (this.hasQE) {
            for (int i2 = 0; i2 < this.rawString.length(); ++i2) {
                char c2 = this.rawString.charAt(i2);
                if (c2 == '\"' || c2 == '\\') {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c2);
            }
        } else {
            stringBuffer.append(this.rawString);
        }
        stringBuffer.append('\"');
    }

    private String makeEscaped(String string) {
        int n2 = string.length();
        if (n2 == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n2 * 2);
        block5: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case ' ': {
                    if (i2 == 0 || i2 == n2 - 1) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(' ');
                    continue block5;
                }
                case '\"': 
                case '\\': {
                    this.hasQE = true;
                }
                case '#': 
                case '+': 
                case ',': 
                case ';': 
                case '<': 
                case '=': 
                case '>': {
                    stringBuffer.append('\\');
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
        }
        return stringBuffer.toString();
    }

    public String makeCanonical() {
        int n2;
        int n3 = this.rawString.length();
        if (n3 == 0) {
            return this.rawString;
        }
        StringBuffer stringBuffer = new StringBuffer(n3 * 2);
        int n4 = 0;
        if (this.rawString.charAt(0) == '#') {
            stringBuffer.append('\\');
            stringBuffer.append('#');
            ++n4;
        }
        while (n4 < n3) {
            char c2 = this.rawString.charAt(n4);
            switch (c2) {
                case ' ': {
                    n2 = stringBuffer.length();
                    if (n2 == 0 || stringBuffer.charAt(n2 - 1) == ' ') break;
                    stringBuffer.append(' ');
                    break;
                }
                case '\"': 
                case '+': 
                case ',': 
                case ';': 
                case '<': 
                case '>': 
                case '\\': {
                    stringBuffer.append('\\');
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
            ++n4;
        }
        for (n2 = stringBuffer.length() - 1; n2 > -1 && stringBuffer.charAt(n2) == ' '; --n2) {
        }
        stringBuffer.setLength(n2 + 1);
        return stringBuffer.toString();
    }
}

