/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;

class DHKeyGeneratorHelper {
    private static final int MAX_ITERATIONS = 1000;
    static final DHKeyGeneratorHelper INSTANCE = new DHKeyGeneratorHelper();
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    private DHKeyGeneratorHelper() {
    }

    BigInteger calculatePrivate(BigInteger bigInteger, SecureRandom secureRandom, int n2) {
        BigInteger bigInteger2;
        BigInteger bigInteger3 = bigInteger.subtract(TWO);
        if (n2 == 0) {
            bigInteger2 = this.createInRange(bigInteger3, secureRandom);
        } else {
            while ((bigInteger2 = new BigInteger(n2, 0, secureRandom)).equals(ZERO)) {
            }
        }
        return bigInteger2;
    }

    private BigInteger createInRange(BigInteger bigInteger, SecureRandom secureRandom) {
        BigInteger bigInteger2;
        int n2 = bigInteger.bitLength();
        int n3 = 0;
        while (((bigInteger2 = new BigInteger(n2, secureRandom)).equals(ZERO) || bigInteger2.compareTo(bigInteger) > 0) && ++n3 != 1000) {
        }
        if (n3 == 1000) {
            return new BigInteger(n2 - 1, secureRandom).setBit(0);
        }
        return bigInteger2;
    }

    BigInteger calculatePublic(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        return bigInteger2.modPow(bigInteger3, bigInteger);
    }
}

