/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarException;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

final class JarVerifierImpl {
    private static final boolean debug = false;
    private URL jarURL;

    JarVerifierImpl(URL uRL) {
        this.jarURL = uRL;
    }

    void verify(X509Certificate x509Certificate) throws JarException, IOException {
        try {
            this.verifyJars(this.jarURL, null, x509Certificate);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new JarException("Cannot verify " + this.jarURL.toString());
        }
        catch (CertificateException certificateException) {
            throw new JarException("Cannot verify " + this.jarURL.toString());
        }
    }

    private void verifyJars(URL uRL, Vector vector, X509Certificate x509Certificate) throws NoSuchProviderException, CertificateException, IOException {
        String string = uRL.toString();
        if (vector == null || !vector.contains(string)) {
            String string2 = this.verifySingleJar(uRL, x509Certificate);
            if (vector != null) {
                vector.addElement(string);
            }
            if (string2 != null) {
                if (vector == null) {
                    vector = new Vector<String>();
                    vector.addElement(string);
                }
                this.verifyManifestClassPathJars(uRL, string2, vector, x509Certificate);
            }
        }
    }

    private void verifyManifestClassPathJars(URL uRL, String string, Vector vector, X509Certificate x509Certificate) throws NoSuchProviderException, CertificateException, IOException {
        String[] stringArray = JarVerifierImpl.parseAttrClasspath(string);
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                URL uRL2 = new URL(uRL, stringArray[i2]);
                this.verifyJars(uRL2, vector, x509Certificate);
            }
        }
        catch (MalformedURLException malformedURLException) {
            MalformedURLException malformedURLException2 = new MalformedURLException("The JAR file " + uRL.toString() + " contains invalid URLs in its Class-Path attribute");
            malformedURLException2.initCause(malformedURLException);
            throw malformedURLException2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String verifySingleJar(URL uRL, X509Certificate x509Certificate) throws NoSuchProviderException, CertificateException, IOException {
        final URL uRL2 = uRL.getProtocol().equalsIgnoreCase("jar") ? uRL : new URL("jar:" + uRL.toString() + "!/");
        JarFile jarFile = null;
        try {
            Object object;
            Cloneable cloneable;
            try {
                jarFile = (JarFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        JarURLConnection jarURLConnection = (JarURLConnection)uRL2.openConnection();
                        return jarURLConnection.getJarFile();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                SecurityException securityException = new SecurityException("Cannot verify " + uRL2.toString());
                securityException.initCause(privilegedActionException);
                throw securityException;
            }
            byte[] byArray = new byte[8192];
            Vector<Cloneable> vector = new Vector<Cloneable>();
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                cloneable = enumeration.nextElement();
                vector.addElement(cloneable);
                object = jarFile.getInputStream((ZipEntry)cloneable);
                try {
                    int n2;
                    while ((n2 = ((InputStream)object).read(byArray, 0, byArray.length)) != -1) {
                    }
                }
                finally {
                    ((InputStream)object).close();
                }
            }
            cloneable = jarFile.getManifest();
            if (cloneable == null) {
                throw new JarException(uRL.toString() + " is not signed.");
            }
            object = jarFile.entries();
            while (object.hasMoreElements()) {
                X509Certificate[] x509CertificateArray;
                JarEntry jarEntry = (JarEntry)object.nextElement();
                if (jarEntry.isDirectory()) continue;
                Certificate[] certificateArray = jarEntry.getCertificates();
                if (certificateArray == null || certificateArray.length == 0) {
                    if (jarEntry.getName().startsWith("META-INF")) continue;
                    throw new JarException(uRL.toString() + " has unsigned entries - " + jarEntry.getName());
                }
                int n3 = 0;
                boolean bl = false;
                while ((x509CertificateArray = JarVerifierImpl.getAChain(certificateArray, n3)) != null) {
                    if (x509Certificate.equals(x509CertificateArray[0])) {
                        bl = true;
                        break;
                    }
                    n3 += x509CertificateArray.length;
                }
                if (bl) continue;
                throw new JarException(uRL.toString() + " is not signed by a" + " trusted signer.");
            }
            String string = ((Manifest)cloneable).getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            return string;
        }
        finally {
            if (jarFile != null) {
                jarFile = null;
            }
        }
    }

    private static String[] parseAttrClasspath(String string) throws JarException {
        string = string.trim();
        int n2 = string.indexOf(32);
        String string2 = null;
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        do {
            if (n2 > 0) {
                string2 = string.substring(0, n2);
                string = string.substring(n2 + 1).trim();
                n2 = string.indexOf(32);
            } else {
                string2 = string;
                bl = true;
            }
            if (!string2.endsWith(".jar")) {
                throw new JarException("The provider contains un-verifiable components");
            }
            vector.addElement(string2);
        } while (!bl);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static X509Certificate[] getAChain(Certificate[] certificateArray, int n2) {
        int n3;
        if (n2 > certificateArray.length - 1) {
            return null;
        }
        for (n3 = n2; n3 < certificateArray.length - 1 && ((Object)((X509Certificate)certificateArray[n3 + 1]).getSubjectDN()).equals(((X509Certificate)certificateArray[n3]).getIssuerDN()); ++n3) {
        }
        int n4 = n3 - n2 + 1;
        X509Certificate[] x509CertificateArray = new X509Certificate[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            x509CertificateArray[i2] = (X509Certificate)certificateArray[n2 + i2];
        }
        return x509CertificateArray;
    }

    static boolean doVerification(final Class clazz, String string) {
        X509Certificate x509Certificate;
        Object object;
        Object object2;
        try {
            object2 = CertificateFactory.getInstance("X.509");
            object = string.getBytes("UTF8");
            x509Certificate = (X509Certificate)((CertificateFactory)object2).generateCertificate(new ByteArrayInputStream((byte[])object));
        }
        catch (Exception exception) {
            return false;
        }
        object2 = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
                return codeSource.getLocation();
            }
        });
        if (object2 == null) {
            return false;
        }
        object = new JarVerifierImpl((URL)object2);
        try {
            ((JarVerifierImpl)object).verify(x509Certificate);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

