/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import sun.nio.ch.DirectBuffer;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.P11SecretKeyFactory;
import sun.security.pkcs11.P11Util;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class P11Cipher
extends CipherSpi {
    private static final int MODE_ECB = 3;
    private static final int MODE_CBC = 4;
    private static final int PAD_NONE = 5;
    private static final int PAD_PKCS5 = 6;
    private final Token token;
    private final String algorithm;
    private final String keyAlgorithm;
    private final long mechanism;
    private Session session;
    private P11Key p11Key;
    private boolean initialized;
    private boolean encrypt;
    private int blockMode;
    private final int blockSize;
    private int paddingType;
    private Padding paddingObj;
    private byte[] padBuffer;
    private int padBufferLen;
    private byte[] iv;
    private int bytesBuffered;

    P11Cipher(Token token, String string, long l2) throws PKCS11Exception, NoSuchAlgorithmException {
        this.token = token;
        this.algorithm = string;
        this.mechanism = l2;
        String[] stringArray = string.split("/");
        this.keyAlgorithm = stringArray[0];
        this.blockSize = this.keyAlgorithm.equals("AES") ? 16 : (this.keyAlgorithm.equals("RC4") || this.keyAlgorithm.equals("ARCFOUR") ? 0 : 8);
        this.blockMode = stringArray.length > 1 ? this.parseMode(stringArray[1]) : 3;
        String string2 = this.blockSize == 0 ? "NoPadding" : "PKCS5Padding";
        String string3 = stringArray.length > 2 ? stringArray[2] : string2;
        try {
            this.engineSetPadding(string3);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new ProviderException(noSuchPaddingException);
        }
    }

    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException("Unsupported mode " + string);
    }

    private int parseMode(String string) throws NoSuchAlgorithmException {
        int n2;
        if ((string = string.toUpperCase()).equals("ECB")) {
            n2 = 3;
        } else if (string.equals("CBC")) {
            if (this.blockSize == 0) {
                throw new NoSuchAlgorithmException("CBC mode not supported with stream ciphers");
            }
            n2 = 4;
        } else {
            throw new NoSuchAlgorithmException("Unsupported mode " + string);
        }
        return n2;
    }

    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        this.paddingObj = null;
        this.padBuffer = null;
        if ((string = string.toUpperCase()).equals("NOPADDING")) {
            this.paddingType = 5;
        } else if (string.equals("PKCS5PADDING")) {
            this.paddingType = 6;
            if (this.mechanism != 293L && this.mechanism != 310L && this.mechanism != 4229L) {
                this.paddingObj = new PKCS5Padding(this.blockSize);
                this.padBuffer = new byte[this.blockSize];
            }
        } else {
            throw new NoSuchPaddingException("Unsupported padding " + string);
        }
    }

    protected int engineGetBlockSize() {
        return this.blockSize;
    }

    protected int engineGetOutputSize(int n2) {
        return this.doFinalLength(n2);
    }

    protected byte[] engineGetIV() {
        return this.iv == null ? null : (byte[])this.iv.clone();
    }

    protected AlgorithmParameters engineGetParameters() {
        if (this.iv == null) {
            return null;
        }
        IvParameterSpec ivParameterSpec = new IvParameterSpec(this.iv);
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(this.keyAlgorithm, P11Util.getSunJceProvider());
            algorithmParameters.init(ivParameterSpec);
            return algorithmParameters;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ProviderException("Could not encode parameters", generalSecurityException);
        }
    }

    protected void engineInit(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.implInit(n2, key, null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException("init() failed", invalidAlgorithmParameterException);
        }
    }

    protected void engineInit(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        byte[] byArray;
        if (algorithmParameterSpec != null) {
            if (!(algorithmParameterSpec instanceof IvParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Only IvParameterSpec supported");
            }
            IvParameterSpec ivParameterSpec = (IvParameterSpec)algorithmParameterSpec;
            byArray = ivParameterSpec.getIV();
        } else {
            byArray = null;
        }
        this.implInit(n2, key, byArray, secureRandom);
    }

    protected void engineInit(int n2, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        byte[] byArray;
        if (algorithmParameters != null) {
            try {
                IvParameterSpec ivParameterSpec = algorithmParameters.getParameterSpec(IvParameterSpec.class);
                byArray = ivParameterSpec.getIV();
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new InvalidAlgorithmParameterException("Could not decode IV", invalidParameterSpecException);
            }
        } else {
            byArray = null;
        }
        this.implInit(n2, key, byArray, secureRandom);
    }

    private void implInit(int n2, Key key, byte[] byArray, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cancelOperation();
        switch (n2) {
            case 1: {
                this.encrypt = true;
                break;
            }
            case 2: {
                this.encrypt = false;
                break;
            }
            default: {
                throw new InvalidAlgorithmParameterException("Unsupported mode: " + n2);
            }
        }
        if (this.blockMode == 3) {
            if (byArray != null) {
                if (this.blockSize == 0) {
                    throw new InvalidAlgorithmParameterException("IV not used with stream ciphers");
                }
                throw new InvalidAlgorithmParameterException("IV not used in ECB mode");
            }
        } else if (byArray == null) {
            if (!this.encrypt) {
                throw new InvalidAlgorithmParameterException("IV must be specified for decryption in CBC mode");
            }
            if (secureRandom == null) {
                secureRandom = new SecureRandom();
            }
            byArray = new byte[this.blockSize];
            secureRandom.nextBytes(byArray);
        } else if (byArray.length != this.blockSize) {
            throw new InvalidAlgorithmParameterException("IV length must match block size");
        }
        this.iv = byArray;
        this.p11Key = P11SecretKeyFactory.convertKey(this.token, key, this.keyAlgorithm);
        try {
            this.initialize();
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new InvalidKeyException("Could not initialize cipher", pKCS11Exception);
        }
    }

    private void cancelOperation() {
        if (!this.initialized) {
            return;
        }
        this.initialized = false;
        if (this.session == null || !this.token.explicitCancel) {
            return;
        }
        int n2 = this.doFinalLength(0);
        byte[] byArray = new byte[n2];
        try {
            if (this.encrypt) {
                this.token.p11.C_EncryptFinal(this.session.id(), 0L, byArray, 0, n2);
            } else {
                this.token.p11.C_DecryptFinal(this.session.id(), 0L, byArray, 0, n2);
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException("Cancel failed", pKCS11Exception);
        }
    }

    private void ensureInitialized() throws PKCS11Exception {
        if (!this.initialized) {
            this.initialize();
        }
    }

    private void initialize() throws PKCS11Exception {
        if (this.session == null) {
            this.session = this.token.getOpSession();
        }
        if (this.encrypt) {
            this.token.p11.C_EncryptInit(this.session.id(), new CK_MECHANISM(this.mechanism, this.iv), this.p11Key.keyID);
        } else {
            this.token.p11.C_DecryptInit(this.session.id(), new CK_MECHANISM(this.mechanism, this.iv), this.p11Key.keyID);
        }
        this.bytesBuffered = 0;
        this.padBufferLen = 0;
        this.initialized = true;
    }

    private int updateLength(int n2) {
        if (n2 <= 0) {
            return 0;
        }
        int n3 = n2 + this.bytesBuffered;
        if (this.blockSize != 0) {
            n3 -= n3 & this.blockSize - 1;
        }
        return n3;
    }

    private int doFinalLength(int n2) {
        if (n2 < 0) {
            return 0;
        }
        int n3 = n2 + this.bytesBuffered;
        if (this.blockSize != 0 && this.encrypt && this.paddingType != 5) {
            n3 += this.blockSize - (n3 & this.blockSize - 1);
        }
        return n3;
    }

    protected byte[] engineUpdate(byte[] byArray, int n2, int n3) {
        try {
            byte[] byArray2 = new byte[this.updateLength(n3)];
            int n4 = this.engineUpdate(byArray, n2, n3, byArray2, 0);
            return P11Util.convert(byArray2, 0, n4);
        }
        catch (ShortBufferException shortBufferException) {
            throw new ProviderException(shortBufferException);
        }
    }

    protected int engineUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException {
        int n5 = byArray2.length - n4;
        return this.implUpdate(byArray, n2, n3, byArray2, n4, n5);
    }

    protected int engineUpdate(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws ShortBufferException {
        return this.implUpdate(byteBuffer, byteBuffer2);
    }

    protected byte[] engineDoFinal(byte[] byArray, int n2, int n3) throws IllegalBlockSizeException, BadPaddingException {
        try {
            byte[] byArray2 = new byte[this.doFinalLength(n3)];
            int n4 = this.engineDoFinal(byArray, n2, n3, byArray2, 0);
            return P11Util.convert(byArray2, 0, n4);
        }
        catch (ShortBufferException shortBufferException) {
            throw new ProviderException(shortBufferException);
        }
    }

    protected int engineDoFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int n5 = 0;
        if (n3 != 0 && byArray != null) {
            n5 = this.engineUpdate(byArray, n2, n3, byArray2, n4);
            n4 += n5;
        }
        return n5 += this.implDoFinal(byArray2, n4, byArray2.length - n4);
    }

    protected int engineDoFinal(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int n2 = this.engineUpdate(byteBuffer, byteBuffer2);
        return n2 += this.implDoFinal(byteBuffer2);
    }

    private int implUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) throws ShortBufferException {
        if (n5 < this.updateLength(n3)) {
            throw new ShortBufferException();
        }
        try {
            this.ensureInitialized();
            int n6 = 0;
            if (this.encrypt) {
                n6 = this.token.p11.C_EncryptUpdate(this.session.id(), 0L, byArray, n2, n3, 0L, byArray2, n4, n5);
            } else {
                int n7 = 0;
                if (this.paddingObj != null) {
                    if (this.padBufferLen != 0) {
                        if (this.padBufferLen != this.padBuffer.length) {
                            int n8 = this.padBuffer.length - this.padBufferLen;
                            if (n3 > n8) {
                                this.bufferInputBytes(byArray, n2, n8);
                                n2 += n8;
                                n3 -= n8;
                            } else {
                                this.bufferInputBytes(byArray, n2, n3);
                                return 0;
                            }
                        }
                        n6 = this.token.p11.C_DecryptUpdate(this.session.id(), 0L, this.padBuffer, 0, this.padBufferLen, 0L, byArray2, n4, n5);
                        this.padBufferLen = 0;
                    }
                    if ((n7 = n3 & this.blockSize - 1) == 0) {
                        n7 = this.padBuffer.length;
                    }
                    n3 -= n7;
                }
                if (n3 > 0) {
                    n6 += this.token.p11.C_DecryptUpdate(this.session.id(), 0L, byArray, n2, n3, 0L, byArray2, n4 + n6, n5 - n6);
                }
                if (this.paddingObj != null) {
                    this.bufferInputBytes(byArray, n2 + n3, n7);
                }
            }
            this.bytesBuffered += n3 - n6;
            return n6;
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (pKCS11Exception.getErrorCode() == 336L) {
                throw (ShortBufferException)new ShortBufferException().initCause(pKCS11Exception);
            }
            throw new ProviderException("update() failed", pKCS11Exception);
        }
    }

    private int implUpdate(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws ShortBufferException {
        int n2 = byteBuffer.remaining();
        if (n2 <= 0) {
            return 0;
        }
        int n3 = byteBuffer2.remaining();
        if (n3 < this.updateLength(n2)) {
            throw new ShortBufferException();
        }
        int n4 = byteBuffer.position();
        try {
            this.ensureInitialized();
            long l2 = 0L;
            int n5 = 0;
            byte[] byArray = null;
            if (byteBuffer instanceof DirectBuffer) {
                l2 = ((DirectBuffer)((Object)byteBuffer)).address();
                n5 = n4;
            } else if (byteBuffer.hasArray()) {
                byArray = byteBuffer.array();
                n5 = n4 + byteBuffer.arrayOffset();
            }
            long l3 = 0L;
            int n6 = 0;
            byte[] byArray2 = null;
            if (byteBuffer2 instanceof DirectBuffer) {
                l3 = ((DirectBuffer)((Object)byteBuffer2)).address();
                n6 = byteBuffer2.position();
            } else if (byteBuffer2.hasArray()) {
                byArray2 = byteBuffer2.array();
                n6 = byteBuffer2.position() + byteBuffer2.arrayOffset();
            } else {
                byArray2 = new byte[n3];
            }
            int n7 = 0;
            if (this.encrypt) {
                if (l2 == 0L && byArray == null) {
                    byArray = new byte[n2];
                    byteBuffer.get(byArray);
                } else {
                    byteBuffer.position(n4 + n2);
                }
                n7 = this.token.p11.C_EncryptUpdate(this.session.id(), l2, byArray, n5, n2, l3, byArray2, n6, n3);
            } else {
                int n8 = 0;
                if (this.paddingObj != null) {
                    if (this.padBufferLen != 0) {
                        if (this.padBufferLen != this.padBuffer.length) {
                            int n9 = this.padBuffer.length - this.padBufferLen;
                            if (n2 > n9) {
                                this.bufferInputBytes(byteBuffer, n9);
                                n5 += n9;
                                n2 -= n9;
                            } else {
                                this.bufferInputBytes(byteBuffer, n2);
                                return 0;
                            }
                        }
                        n7 = this.token.p11.C_DecryptUpdate(this.session.id(), 0L, this.padBuffer, 0, this.padBufferLen, l3, byArray2, n6, n3);
                        this.padBufferLen = 0;
                    }
                    if ((n8 = n2 & this.blockSize - 1) == 0) {
                        n8 = this.padBuffer.length;
                    }
                    n2 -= n8;
                }
                if (n2 > 0) {
                    if (l2 == 0L && byArray == null) {
                        byArray = new byte[n2];
                        byteBuffer.get(byArray);
                    } else {
                        byteBuffer.position(byteBuffer.position() + n2);
                    }
                    n7 += this.token.p11.C_DecryptUpdate(this.session.id(), l2, byArray, n5, n2, l3, byArray2, n6 + n7, n3 - n7);
                }
                if (this.paddingObj != null && n8 != 0) {
                    this.bufferInputBytes(byteBuffer, n8);
                }
            }
            this.bytesBuffered += n2 - n7;
            if (!(byteBuffer2 instanceof DirectBuffer) && !byteBuffer2.hasArray()) {
                byteBuffer2.put(byArray2, n6, n7);
            } else {
                byteBuffer2.position(byteBuffer2.position() + n7);
            }
            return n7;
        }
        catch (PKCS11Exception pKCS11Exception) {
            byteBuffer.position(n4);
            if (pKCS11Exception.getErrorCode() == 336L) {
                throw (ShortBufferException)new ShortBufferException().initCause(pKCS11Exception);
            }
            throw new ProviderException("update() failed", pKCS11Exception);
        }
    }

    private int implDoFinal(byte[] byArray, int n2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int n4 = this.doFinalLength(0);
        if (n3 < n4) {
            throw new ShortBufferException();
        }
        try {
            int n5;
            this.ensureInitialized();
            int n6 = 0;
            if (this.encrypt) {
                if (this.paddingObj != null) {
                    n5 = this.paddingObj.setPaddingBytes(this.padBuffer, n4 - this.bytesBuffered);
                    n6 = this.token.p11.C_EncryptUpdate(this.session.id(), 0L, this.padBuffer, 0, n5, 0L, byArray, n2, n3);
                }
                n6 += this.token.p11.C_EncryptFinal(this.session.id(), 0L, byArray, n2 + n6, n3 - n6);
            } else if (this.paddingObj != null) {
                if (this.padBufferLen != 0) {
                    n6 = this.token.p11.C_DecryptUpdate(this.session.id(), 0L, this.padBuffer, 0, this.padBufferLen, 0L, this.padBuffer, 0, this.padBuffer.length);
                }
                if ((n6 += this.token.p11.C_DecryptFinal(this.session.id(), 0L, this.padBuffer, n6, this.padBuffer.length - n6)) != this.blockSize) {
                    throw new IllegalBlockSizeException("Input length must be multiple of " + this.blockSize);
                }
                n5 = this.paddingObj.unpad(this.padBuffer, n6);
                System.arraycopy(this.padBuffer, 0, byArray, n2, n6 -= n5);
            } else {
                n6 = this.token.p11.C_DecryptFinal(this.session.id(), 0L, byArray, n2, n3);
            }
            n5 = n6;
            return n5;
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.handleException(pKCS11Exception);
            throw new ProviderException("doFinal() failed", pKCS11Exception);
        }
        finally {
            this.initialized = false;
            this.bytesBuffered = 0;
            this.padBufferLen = 0;
            this.session = this.token.releaseSession(this.session);
        }
    }

    private int implDoFinal(ByteBuffer byteBuffer) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int n2;
        int n3 = byteBuffer.remaining();
        if (n3 < (n2 = this.doFinalLength(0))) {
            throw new ShortBufferException();
        }
        try {
            int n4;
            this.ensureInitialized();
            long l2 = 0L;
            byte[] byArray = null;
            int n5 = 0;
            if (byteBuffer instanceof DirectBuffer) {
                l2 = ((DirectBuffer)((Object)byteBuffer)).address();
                n5 = byteBuffer.position();
            } else if (byteBuffer.hasArray()) {
                byArray = byteBuffer.array();
                n5 = byteBuffer.position() + byteBuffer.arrayOffset();
            } else {
                byArray = new byte[n3];
            }
            int n6 = 0;
            if (this.encrypt) {
                if (this.paddingObj != null) {
                    n4 = this.paddingObj.setPaddingBytes(this.padBuffer, n2 - this.bytesBuffered);
                    n6 = this.token.p11.C_EncryptUpdate(this.session.id(), 0L, this.padBuffer, 0, n4, l2, byArray, n5, n3);
                }
                n6 += this.token.p11.C_EncryptFinal(this.session.id(), l2, byArray, n5 + n6, n3 - n6);
            } else if (this.paddingObj != null) {
                if (this.padBufferLen != 0) {
                    n6 = this.token.p11.C_DecryptUpdate(this.session.id(), 0L, this.padBuffer, 0, this.padBufferLen, 0L, this.padBuffer, 0, this.padBuffer.length);
                    this.padBufferLen = 0;
                }
                if ((n6 += this.token.p11.C_DecryptFinal(this.session.id(), 0L, this.padBuffer, n6, this.padBuffer.length - n6)) != this.blockSize) {
                    throw new IllegalBlockSizeException("Input length must be multiple of " + this.blockSize);
                }
                n4 = this.paddingObj.unpad(this.padBuffer, n6);
                n6 -= n4;
                byArray = this.padBuffer;
                n5 = 0;
            } else {
                n6 = this.token.p11.C_DecryptFinal(this.session.id(), l2, byArray, n5, n3);
            }
            if (!this.encrypt && this.paddingObj != null || !(byteBuffer instanceof DirectBuffer) && !byteBuffer.hasArray()) {
                byteBuffer.put(byArray, n5, n6);
            } else {
                byteBuffer.position(byteBuffer.position() + n6);
            }
            n4 = n6;
            return n4;
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.handleException(pKCS11Exception);
            throw new ProviderException("doFinal() failed", pKCS11Exception);
        }
        finally {
            this.initialized = false;
            this.bytesBuffered = 0;
            this.session = this.token.releaseSession(this.session);
        }
    }

    private void handleException(PKCS11Exception pKCS11Exception) throws ShortBufferException, IllegalBlockSizeException {
        long l2 = pKCS11Exception.getErrorCode();
        if (l2 == 336L) {
            throw (ShortBufferException)new ShortBufferException().initCause(pKCS11Exception);
        }
        if (l2 == 33L || l2 == 65L) {
            throw (IllegalBlockSizeException)new IllegalBlockSizeException(pKCS11Exception.toString()).initCause(pKCS11Exception);
        }
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        throw new UnsupportedOperationException("engineWrap()");
    }

    protected Key engineUnwrap(byte[] byArray, String string, int n2) throws InvalidKeyException, NoSuchAlgorithmException {
        throw new UnsupportedOperationException("engineUnwrap()");
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        int n2 = P11SecretKeyFactory.convertKey(this.token, key, this.keyAlgorithm).keyLength();
        return n2;
    }

    private final void bufferInputBytes(byte[] byArray, int n2, int n3) {
        System.arraycopy(byArray, n2, this.padBuffer, this.padBufferLen, n3);
        this.padBufferLen += n3;
        this.bytesBuffered += n3;
    }

    private final void bufferInputBytes(ByteBuffer byteBuffer, int n2) {
        byteBuffer.get(this.padBuffer, this.padBufferLen, n2);
        this.padBufferLen += n2;
        this.bytesBuffered += n2;
    }

    private static class PKCS5Padding
    implements Padding {
        private final int blockSize;

        PKCS5Padding(int n2) throws NoSuchPaddingException {
            if (n2 == 0) {
                throw new NoSuchPaddingException("PKCS#5 padding not supported with stream ciphers");
            }
            this.blockSize = n2;
        }

        public int setPaddingBytes(byte[] byArray, int n2) {
            Arrays.fill(byArray, 0, n2, (byte)(n2 & 0x7F));
            return n2;
        }

        public int unpad(byte[] byArray, int n2) throws BadPaddingException {
            int n3;
            if (n2 < 1 || n2 > byArray.length) {
                throw new BadPaddingException("Invalid pad array length!");
            }
            byte by = byArray[n2 - 1];
            if (by < 1 || by > this.blockSize) {
                throw new BadPaddingException("Invalid pad value!");
            }
            for (int i2 = n3 = n2 - by; i2 < n2; ++i2) {
                if (byArray[i2] == by) continue;
                throw new BadPaddingException("Invalid pad bytes!");
            }
            return by;
        }
    }

    private static interface Padding {
        public int setPaddingBytes(byte[] var1, int var2);

        public int unpad(byte[] var1, int var2) throws BadPaddingException;
    }
}

