/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.ProviderException;
import java.security.Security;

public final class P11Util {
    private static Object LOCK = new Object();
    private static volatile Provider sun;
    private static volatile Provider sunRsaSign;
    private static volatile Provider sunJce;
    private static final char[] hexDigits;

    private P11Util() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Provider getSunProvider() {
        Provider provider = sun;
        if (provider == null) {
            Object object = LOCK;
            synchronized (object) {
                sun = provider = P11Util.getProvider(sun, "SUN", "sun.security.provider.Sun");
            }
        }
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Provider getSunRsaSignProvider() {
        Provider provider = sunRsaSign;
        if (provider == null) {
            Object object = LOCK;
            synchronized (object) {
                sunRsaSign = provider = P11Util.getProvider(sunRsaSign, "SunRsaSign", "sun.security.rsa.SunRsaSign");
            }
        }
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Provider getSunJceProvider() {
        Provider provider = sunJce;
        if (provider == null) {
            Object object = LOCK;
            synchronized (object) {
                sunJce = provider = P11Util.getProvider(sunJce, "SunJCE", "com.sun.crypto.provider.SunJCE");
            }
        }
        return provider;
    }

    private static Provider getProvider(Provider provider, String string, String string2) {
        if (provider != null) {
            return provider;
        }
        provider = Security.getProvider(string);
        if (provider == null) {
            try {
                Class<?> clazz = Class.forName(string2);
                provider = (Provider)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new ProviderException("Could not find provider " + string, exception);
            }
        }
        return provider;
    }

    static byte[] convert(byte[] byArray, int n2, int n3) {
        if (n2 == 0 && n3 == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        return byArray2;
    }

    static byte[] subarray(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        return byArray2;
    }

    static byte[] concat(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    static long[] concat(long[] lArray, long[] lArray2) {
        if (lArray.length == 0) {
            return lArray2;
        }
        long[] lArray3 = new long[lArray.length + lArray2.length];
        System.arraycopy(lArray, 0, lArray3, 0, lArray.length);
        System.arraycopy(lArray2, 0, lArray3, lArray.length, lArray2.length);
        return lArray3;
    }

    static byte[] trimZeroes(byte[] byArray) {
        int n2;
        for (n2 = 0; n2 < byArray.length - 1 && byArray[n2] == 0; ++n2) {
        }
        if (n2 == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length - n2];
        System.arraycopy(byArray, n2, byArray2, 0, byArray2.length);
        return byArray2;
    }

    public static byte[] getMagnitude(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length > 1 && byArray[0] == 0) {
            int n2 = byArray.length - 1;
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 1, byArray2, 0, n2);
            byArray = byArray2;
        }
        return byArray;
    }

    static byte[] getBytesUTF8(String string) {
        try {
            return string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    static byte[] sha1(byte[] byArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.update(byArray);
            return messageDigest.digest();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ProviderException(generalSecurityException);
        }
    }

    static String toString(byte[] byArray) {
        if (byArray == null) {
            return "(null)";
        }
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 3);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = byArray[i2] & 0xFF;
            if (i2 != 0) {
                stringBuffer.append(':');
            }
            stringBuffer.append(hexDigits[n2 >>> 4]);
            stringBuffer.append(hexDigits[n2 & 0xF]);
        }
        return stringBuffer.toString();
    }

    static {
        hexDigits = "0123456789abcdef".toCharArray();
    }
}

