/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.security.ProviderException;
import java.util.concurrent.atomic.AtomicInteger;
import sun.security.pkcs11.SessionRef;
import sun.security.pkcs11.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Session
implements Comparable<Session> {
    private static final long MAX_IDLE_TIME = 180000L;
    final Token token;
    private final long id;
    private final AtomicInteger createdObjects;
    private long lastAccess;
    private final SessionRef sessionRef;

    Session(Token token, long l2) {
        this.token = token;
        this.id = l2;
        this.createdObjects = new AtomicInteger();
        this.id();
        this.sessionRef = new SessionRef(this, l2, token);
    }

    @Override
    public int compareTo(Session session) {
        if (this.lastAccess == session.lastAccess) {
            return 0;
        }
        return this.lastAccess < session.lastAccess ? -1 : 1;
    }

    boolean isLive(long l2) {
        return l2 - this.lastAccess < 180000L;
    }

    long idInternal() {
        return this.id;
    }

    long id() {
        if (!this.token.isPresent(this)) {
            throw new ProviderException("Token has been removed");
        }
        this.lastAccess = System.currentTimeMillis();
        return this.id;
    }

    void addObject() {
        int n2 = this.createdObjects.incrementAndGet();
    }

    void removeObject() {
        int n2 = this.createdObjects.decrementAndGet();
        if (n2 == 0) {
            this.token.sessionManager.demoteObjSession(this);
        } else if (n2 < 0) {
            throw new ProviderException("Internal error: objects created " + n2);
        }
    }

    boolean hasObjects() {
        return this.createdObjects.get() != 0;
    }

    void close() {
        if (this.hasObjects()) {
            throw new ProviderException("Internal error: close session with active objects");
        }
        this.sessionRef.dispose();
    }
}

