/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import util.GUIUtils;

class ExceptionDialog
extends JDialog
implements ActionListener {
    private JButton okButton;
    private Icon icon;
    private JLabel titleLabel;
    private JTextArea messageArea;
    private JScrollPane detailsPanel;
    private JTextArea detailsMessage;
    private JDialog dialog = this;

    public ExceptionDialog(JFrame parentFrame, String name, String title, String message, Exception e2) {
        super(parentFrame, name, true);
        ImageIcon icon = GUIUtils.getImageIcon("images/exception.gif", "Exception");
        JLabel iconLabel = new JLabel();
        iconLabel.setIcon(icon);
        iconLabel.setAlignmentY(0.0f);
        this.titleLabel = new JLabel(title);
        Font defaultFont = new JLabel().getFont();
        this.titleLabel.setFont(defaultFont.deriveFont(1));
        this.titleLabel.setAlignmentX(0.0f);
        this.messageArea = new JTextArea(5, 30);
        this.messageArea.setEditable(false);
        this.messageArea.setFont(defaultFont.deriveFont(0));
        this.messageArea.setOpaque(false);
        this.messageArea.setLineWrap(true);
        this.messageArea.setWrapStyleWord(true);
        this.messageArea.setText(message);
        this.messageArea.setAlignmentX(0.0f);
        JPanel titleAndMessagePanel = new JPanel();
        titleAndMessagePanel.setLayout(new BoxLayout(titleAndMessagePanel, 1));
        titleAndMessagePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        titleAndMessagePanel.add(this.titleLabel);
        titleAndMessagePanel.add(this.messageArea);
        titleAndMessagePanel.setAlignmentY(0.0f);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 0));
        topPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        topPanel.add(iconLabel);
        topPanel.add(titleAndMessagePanel);
        topPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 75));
        topPanel.setPreferredSize(new Dimension(400, 75));
        Box detailBox = null;
        if (e2 != null) {
            this.detailsMessage = new JTextArea(this.getExceptionDetails(e2));
            this.detailsMessage.setEditable(true);
            this.detailsMessage.setFont(defaultFont.deriveFont(0));
            this.detailsMessage.setOpaque(false);
            this.detailsMessage.setAlignmentX(0.0f);
            JScrollPane detailsPanel = new JScrollPane(this.detailsMessage);
            detailsPanel.setBorder(BorderFactory.createTitledBorder("Details"));
            detailBox = Box.createVerticalBox();
            detailBox.add(detailsPanel);
            detailBox.setPreferredSize(new Dimension(500, 120));
            detailBox.setMaximumSize(new Dimension(Integer.MAX_VALUE, 100));
        }
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c2 = new GridBagConstraints();
        c2.gridx = 0;
        c2.gridy = 0;
        c2.anchor = 17;
        c2.fill = 2;
        mainPanel.add((Component)topPanel, c2);
        if (e2 != null) {
            c2.gridy = 1;
            c2.anchor = 10;
            c2.fill = 0;
            mainPanel.add((Component)detailBox, c2);
        }
        c2.gridy = 2;
        c2.anchor = 10;
        c2.fill = 0;
        mainPanel.add((Component)this.okButton, c2);
        this.getContentPane().add(mainPanel);
        this.pack();
        this.setLocationRelativeTo(parentFrame);
        this.setResizable(false);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.okButton) {
            this.dispose();
        }
    }

    @Override
    public void processWindowEvent(WindowEvent e2) {
        if (e2.getID() == 201) {
            this.dispose();
        }
        super.processWindowEvent(e2);
    }

    public String getExceptionDetails(Throwable e2) {
        StackTraceElement[] stack = e2.getStackTrace();
        String stackString = String.valueOf(e2.toString()) + "\n";
        if (stack == null || stack.length == 0) {
            return stackString;
        }
        stackString = String.valueOf(stackString) + "\nStack details:\n";
        int i2 = 0;
        while (i2 < stack.length) {
            stackString = String.valueOf(stackString) + stack[i2].toString() + "\n";
            ++i2;
        }
        if (e2.getCause() != null) {
            stackString = String.valueOf(stackString) + "\n\nCause:\n" + this.getExceptionDetails(e2.getCause());
        }
        return stackString;
    }
}

