/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import util.Debug;
import util.GUIUtils;

public class GUIPasswordDialog
extends JDialog
implements ActionListener {
    private JPasswordField passField;
    private JButton okButton;
    private JButton cancelButton;
    public boolean chooseOK;
    private boolean firstAsk;
    private String message;
    private Frame parentFrame;
    KeyListener keyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e2) {
            if (e2.getKeyCode() == 27 || e2.getSource() == GUIPasswordDialog.this.cancelButton && e2.getKeyCode() == 10) {
                GUIPasswordDialog.this.chooseOK = false;
                GUIPasswordDialog.this.setVisible(false);
            }
            if (e2.getSource() == GUIPasswordDialog.this.okButton && e2.getKeyCode() == 10) {
                GUIPasswordDialog.this.chooseOK = true;
                GUIPasswordDialog.this.setVisible(false);
            }
        }
    };

    public char[] getPassword() {
        return this.passField.getPassword();
    }

    public GUIPasswordDialog(JFrame parentFrame, String message, boolean firstAsk) {
        super(parentFrame, "Password dialog", true);
        if (parentFrame == null) {
            Debug.println("PasswordDialog: parentFrame=null");
        }
        this.parentFrame = parentFrame;
        this.firstAsk = firstAsk;
        this.message = message;
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        String text = this.firstAsk ? message : "Wrong Password or IO error (invalid file format).\n" + message;
        JTextArea description = GUIUtils.newTextAreaNote(this, text);
        description.setAlignmentX(0.5f);
        description.setPreferredSize(new Dimension(300, 40));
        this.passField = new JPasswordField(10);
        this.passField.setEchoChar('*');
        this.passField.setActionCommand("OK");
        this.passField.addActionListener(this);
        this.passField.setAlignmentX(0.5f);
        this.passField.addKeyListener(this.keyListener);
        this.okButton = new JButton("OK");
        this.okButton.setActionCommand("OK");
        this.okButton.addActionListener(this);
        this.okButton.addKeyListener(this.keyListener);
        this.okButton.setAlignmentX(0.5f);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setActionCommand("CANCEL");
        this.cancelButton.addActionListener(this);
        this.cancelButton.addKeyListener(this.keyListener);
        this.cancelButton.setAlignmentX(0.5f);
        box.add(description);
        box.add(this.passField);
        box.add(this.okButton);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
            }
        });
        this.addKeyListener(this.keyListener);
        this.getContentPane().add(box);
        this.pack();
        this.setLocationRelativeTo(this.parentFrame);
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        String cmd = e2.getActionCommand();
        if (cmd.equals("OK")) {
            this.chooseOK = true;
            this.setVisible(false);
        }
    }
}

