/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.math.BigInteger;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import javax.security.auth.x500.X500Principal;
import util.X500Parser;

public class KeyStoreEntry {
    private KeyStore loadedStore;
    private String alias;
    private String issuer;
    private String issuerCN;
    private String subject;
    private String subjectCN;
    private String expirationDate;
    private BigInteger srlNo;

    public KeyStoreEntry(KeyStore loadedStore, String alias) throws KeyStoreException, CertificateException {
        this.loadedStore = loadedStore;
        Certificate cert = loadedStore.getCertificate(alias);
        if (!(cert instanceof X509Certificate)) {
            throw new CertificateException("Certificate entry should be an X509Certificate");
        }
        X509Certificate x509cert = (X509Certificate)cert;
        this.alias = alias;
        X500Principal subjPrinc = x509cert.getSubjectX500Principal();
        X500Principal issuerPrinc = x509cert.getIssuerX500Principal();
        this.issuer = issuerPrinc.toString();
        this.issuerCN = new X500Parser(issuerPrinc).getCN();
        this.subject = subjPrinc.toString();
        this.subjectCN = new X500Parser(subjPrinc).getCN();
        this.expirationDate = new SimpleDateFormat().format(x509cert.getNotAfter());
        this.srlNo = x509cert.getSerialNumber();
    }

    public String getAlias() {
        return this.alias;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getIssuerCN() {
        return this.issuerCN;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getSubjectCN() {
        return this.subjectCN;
    }

    public String getExpirationDate() {
        return this.expirationDate;
    }

    public BigInteger getSrlNo() {
        return this.srlNo;
    }

    public Provider getProvider() {
        return this.loadedStore.getProvider();
    }

    public KeyStore getLoadedKeyStore() {
        return this.loadedStore;
    }

    public Certificate[] getCertificateChain() throws KeyStoreException {
        return this.loadedStore.getCertificateChain(this.alias);
    }
}

