/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import util.Debug;

public class OperatingSystem {
    public static final String OS_NAME_PROPERTY = "os.name";
    public static final String USER_HOME_PROPERTY = "user.home";
    public static final String FILE_SEPARATOR_PROPERTY = "file.separator";

    public static boolean isWindows() {
        String NOTDEFINED = "not defined";
        String WIN = "Windows";
        String osname = System.getProperty(OS_NAME_PROPERTY, NOTDEFINED);
        if (osname == NOTDEFINED) {
            System.err.println("System propery 'os.name' is not defined.");
            return false;
        }
        return osname.contains(WIN);
    }

    public static void printSystemProperties() {
        Properties prop = System.getProperties();
        Enumeration<Object> keyEnum = prop.keys();
        while (keyEnum.hasMoreElements()) {
            String keyString = (String)keyEnum.nextElement();
            String propString = prop.getProperty(keyString);
            System.out.println(String.valueOf(keyString) + "=" + propString);
        }
    }

    public static String getSeparator() {
        return System.getProperty(FILE_SEPARATOR_PROPERTY);
    }

    public static boolean isFileCaseSensitive() {
        return !OperatingSystem.isWindows();
    }

    public static boolean open(File file) throws Exception {
        try {
            String ext;
            if (!OperatingSystem.isWindows()) {
                throw new Exception("Not implemented for linux and other OS..");
            }
            String filename = file.getName();
            int pointInd = filename.lastIndexOf(".");
            String string = ext = pointInd == -1 && filename.length() > pointInd + 1 ? null : filename.substring(pointInd + 1);
            if (ext == null) {
                throw new Exception("Extension not found in filename: " + filename);
            }
            if (!(ext.equalsIgnoreCase("PDF") || ext.equalsIgnoreCase("TXT") || ext.equalsIgnoreCase("DOC") || ext.equalsIgnoreCase("JPEG") || ext.equalsIgnoreCase("JPG") || ext.equalsIgnoreCase("TIFF") || ext.equalsIgnoreCase("BMP") || ext.equalsIgnoreCase("HTML") || ext.equalsIgnoreCase("HTM") || ext.equalsIgnoreCase("MP3") || ext.equalsIgnoreCase("WAV") || ext.equalsIgnoreCase("RTF") || ext.equalsIgnoreCase("ZIP"))) {
                throw new Exception("Extension not authorized : " + ext);
            }
            String path = file.getAbsolutePath();
            String cmd = "cmd.exe /C \"" + path + "\"";
            Debug.println("OperatingSystem: exec: " + cmd);
            Process proc = Runtime.getRuntime().exec(cmd);
            return true;
        }
        catch (IOException e2) {
            return false;
        }
    }
}

